% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-helpers.R
\name{set_block}
\alias{set_block}
\alias{empty_block}
\title{Prepare blocks of items}
\usage{
set_block(items, traits, names = items, signs = 1)

empty_block()
}
\arguments{
\item{items}{Names of item comparisons to be combined
into one block. Should correspond to variables in the data.}

\item{traits}{Names of the traits to which each item belongs}

\item{names}{Optional names of the items in the output.
Can be used to equate parameters of items across blocks,
if the same item was used in different blocks.}

\item{signs}{Expected signs of the item loadings (1 or -1).}
}
\description{
Prepare blocks of items and incorporate information
about which item belongs to which trait
}
\examples{
set_block(
  items = c("i1", "i2", "i3"),
  traits = c("A", "B", "C")
) +
set_block(
  items = c("i4", "i5", "i6"),
  traits = c("A", "B", "C")
)

}
