% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_geom.R
\name{geom_freemesh}
\alias{geom_freemesh}
\title{Creates any mesh geometry given vertices and face indices}
\usage{
geom_freemesh(name, vertex = NULL, face = NULL, position = c(0, 0,
  0), layer = 1, cache_file = NULL, group = NULL)
}
\arguments{
\item{name}{unique string in a scene to tell apart from different objects}

\item{vertex}{position of each vertices (3 columns)}

\item{face}{face indices indicating which 3 vertices to be linked (3 columns)}

\item{position}{x,y,z location of the geometry}

\item{layer}{visibility of the geometry, used when there are multiple cameras 1 is visible for all cameras}

\item{cache_file}{cache vertex and face data into group}

\item{group}{a GeomGroup object, if null, then the group will be generated automatically}
}
\description{
Creates any mesh geometry given vertices and face indices
}
\details{
When generating a free mesh internally, a group must be specified,
therefore if group is \code{NULL} here, then a group will be generated.
However, it's always recommended to pass a group to the free mesh.
}
\examples{
\donttest{
# Download N27 smoothed white matter
download_N27_surface(surfaces = c('pial', 'white', 'smoothwm'))


# Load different types of hemispheres
surfaces = c('pial')

# Generate N27 group
groups = list(
  create_group('Left Hemisphere'),
  create_group('Right Hemisphere')
)

g = lapply(surfaces, function(s){
  path = sprintf(
    '~/rave_data/others/three_brain/N27/std.141.\%sh.\%s.asc',
    c('l', 'r'), s)
  cache = sprintf(
    '~/rave_data/others/three_brain/N27/N27_std_141_\%sh_\%s.json',
    c('l', 'r'), s)
  lapply(1:2, function(ii){
    side = c('l', 'r')[ii]
    name = sprintf('\%sh - \%s (Template N27)', side, s)

    if(file.exists(cache[[ii]])){

      # For Hemispheres, the name should be fixed: l/rh - surf_type (subject)
      geom_freemesh(name, group = groups[[ii]], cache_file = cache[[ii]])
    }else{
      dat = threeBrain:::read_fs_asc(path[[ii]])
      vertex = dat$vertices[,1:3]
      face = dat$faces[,1:3]
      geom_freemesh(name, vertex = vertex, face = face,
                    group = groups[[ii]], cache_file = cache[[ii]])
    }
  })
})

# Render
threejs_brain(.list = g[[1]], control_presets = c('lh_material', 'rh_material'))


}
}
