% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_all_features.R
\name{plot_all_features}
\alias{plot_all_features}
\title{Produce a heatmap matrix of the calculated feature value vectors and each unique time series with automatic hierarchical clustering.}
\usage{
plot_all_features(
  data,
  is_normalised = FALSE,
  id_var = "id",
  method = c("z-score", "Sigmoid", "RobustSigmoid", "MinMax"),
  clust_method = c("average", "ward.D", "ward.D2", "single", "complete", "mcquitty",
    "median", "centroid"),
  interactive = FALSE
)
}
\arguments{
\item{data}{a dataframe with at least 2 columns called \code{"names"} and \code{"values"}}

\item{is_normalised}{a Boolean as to whether the input feature values have already been scaled. Defaults to \code{FALSE}}

\item{id_var}{a string specifying the ID variable to identify each time series. Defaults to \code{"id"}}

\item{method}{a rescaling/normalising method to apply. Defaults to \code{"RobustSigmoid"}}

\item{clust_method}{the hierarchical clustering method to use for the pairwise correlation plot. Defaults to \code{"average"}}

\item{interactive}{a Boolean as to whether to plot an interactive \code{plotly} graphic. Defaults to \code{FALSE}}
}
\value{
an object of class \code{ggplot} that contains the heatmap graphic
}
\description{
Produce a heatmap matrix of the calculated feature value vectors and each unique time series with automatic hierarchical clustering.
}
\examples{
featMat <- calculate_features(data = simData, 
  id_var = "id", 
  time_var = "timepoint", 
  values_var = "values", 
  group_var = "process", 
  feature_set = "catch22",
  seed = 123)

plot_all_features(featMat, 
  is_normalised = FALSE,
  id_var = "id", 
  method = "RobustSigmoid",
  clust_method = "average",
  interactive = FALSE)

}
\author{
Trent Henderson
}
