% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_runs.R
\name{ls_runs}
\alias{ls_runs}
\title{List training runs}
\usage{
ls_runs(subset = NULL, order = "start", decreasing = TRUE,
  latest_n = NULL, runs_dir = getOption("tfruns.runs_dir", "runs"))
}
\arguments{
\item{subset}{Logical expression indicating rows to keep (missing values are
taken as false). See \code{\link[=subset]{subset()}}.}

\item{order}{Columns to order by (defaults to run start time)}

\item{decreasing}{\code{TRUE} to use decreasing order (e.g. list most recent runs
first)}

\item{latest_n}{Limit query to the \code{latest_n} most recent runs}

\item{runs_dir}{Directory containing runs. Defaults to "runs" beneath the
current working directory (or to the value of the \code{tfruns.runs_dir} R
option if specified).}
}
\value{
Data frame with training runs
}
\description{
List training runs
}
