% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-kernels.R
\name{mcmc_metropolis_adjusted_langevin_algorithm}
\alias{mcmc_metropolis_adjusted_langevin_algorithm}
\title{Runs one step of Metropolis-adjusted Langevin algorithm.}
\usage{
mcmc_metropolis_adjusted_langevin_algorithm(target_log_prob_fn, step_size,
  volatility_fn = NULL, seed = NULL, parallel_iterations = 10,
  name = NULL)
}
\arguments{
\item{target_log_prob_fn}{Function which takes an argument like
\code{current_state} (if it's a list \code{current_state} will be unpacked) and returns its
(possibly unnormalized) log-density under the target distribution.}

\item{step_size}{\code{Tensor} or \code{list} of \code{Tensor}s representing the step
size for the leapfrog integrator. Must broadcast with the shape of
\code{current_state}. Larger step sizes lead to faster progress, but
too-large step sizes make rejection exponentially more likely. When
possible, it's often helpful to match per-variable step sizes to the
standard deviations of the target distribution in each variable.}

\item{volatility_fn}{function which takes an argument like
\code{current_state} (or \code{*current_state} if it's a list) and returns
volatility value at \code{current_state}. Should return a \code{Tensor} or
\code{list} of \code{Tensor}s that must broadcast with the shape of
\code{current_state}. Defaults to the identity function.}

\item{seed}{integer to seed the random number generator.}

\item{parallel_iterations}{the number of coordinates for which the gradients of
the volatility matrix \code{volatility_fn} can be computed in parallel.}

\item{name}{String prefixed to Ops created by this function.
Default value: \code{NULL} (i.e., 'mala_kernel').}
}
\description{
Metropolis-adjusted Langevin algorithm (MALA) is a Markov chain Monte Carlo
(MCMC) algorithm that takes a step of a discretised Langevin diffusion as a
proposal. This class implements one step of MALA using Euler-Maruyama method
for a given \code{current_state} and diagonal preconditioning \code{volatility} matrix.
}
\details{
Mathematical details and derivations can be found in
Roberts and Rosenthal (1998) and Xifara et al. (2013).

The \code{one_step} function can update multiple chains in parallel. It assumes
that all leftmost dimensions of \code{current_state} index independent chain states
(and are therefore updated independently). The output of
\code{target_log_prob_fn(current_state)} should reduce log-probabilities across
all event dimensions. Slices along the rightmost dimensions may have different
target distributions; for example, \code{current_state[0, :]} could have a
different target distribution from \code{current_state[1, :]}. These semantics are
governed by \code{target_log_prob_fn(current_state)}. (The number of independent
chains is \code{tf.size(target_log_prob_fn(current_state))}.)
}
\section{References}{

\itemize{
\item \href{https://doi.org/10.1111/1467-9868.00123}{Gareth Roberts and Jeffrey Rosenthal. Optimal Scaling of Discrete Approximations to Langevin Diffusions. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 60: 255-268, 1998.}
\item \href{https://arxiv.org/abs/1309.2983}{T. Xifara et al. Langevin diffusions and the Metropolis-adjusted Langevin algorithm. arXiv preprint arXiv:1309.2983, 2013.}
}
}

\seealso{
Other mcmc_kernels: \code{\link{mcmc_dual_averaging_step_size_adaptation}},
  \code{\link{mcmc_hamiltonian_monte_carlo}},
  \code{\link{mcmc_metropolis_hastings}},
  \code{\link{mcmc_no_u_turn_sampler}},
  \code{\link{mcmc_random_walk_metropolis}},
  \code{\link{mcmc_replica_exchange_mc}},
  \code{\link{mcmc_simple_step_size_adaptation}},
  \code{\link{mcmc_slice_sampler}},
  \code{\link{mcmc_transformed_transition_kernel}},
  \code{\link{mcmc_uncalibrated_hamiltonian_monte_carlo}},
  \code{\link{mcmc_uncalibrated_langevin}},
  \code{\link{mcmc_uncalibrated_random_walk}}
}
\concept{mcmc_kernels}
