% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_seasonal_state_space_model}
\alias{sts_seasonal_state_space_model}
\title{State space model for a seasonal effect.}
\usage{
sts_seasonal_state_space_model(
  num_timesteps,
  num_seasons,
  drift_scale,
  initial_state_prior,
  observation_noise_scale = 0,
  num_steps_per_season = 1,
  initial_step = 0,
  validate_args = FALSE,
  allow_nan_stats = TRUE,
  name = NULL
)
}
\arguments{
\item{num_timesteps}{Scalar \code{integer} \code{tensor} number of timesteps to model
with this distribution.}

\item{num_seasons}{Scalar \code{integer} number of seasons.}

\item{drift_scale}{Scalar (any additional dimensions are treated as batch
dimensions) \code{float} \code{tensor} indicating the standard deviation of the
change in effect between consecutive occurrences of a given season.
This is assumed to be the same for all seasons.}

\item{initial_state_prior}{instance of \code{tfd_multivariate_normal}
representing the prior distribution on latent states; must
have event shape \verb{[num_seasons]}.}

\item{observation_noise_scale}{Scalar (any additional dimensions are
treated as batch dimensions) \code{float} \code{tensor} indicating the standard
deviation of the observation noise.}

\item{num_steps_per_season}{\code{integer} number of steps in each
season. This may be either a scalar (shape \verb{[]}), in which case all
seasons have the same length, or an array of shape \verb{[num_seasons]},
in which seasons have different length, but remain constant around
different cycles, or an array of shape \verb{[num_cycles, num_seasons]},
in which num_steps_per_season for each season also varies in different
cycle (e.g., a 4 years cycle with leap day). Default value: 1.}

\item{initial_step}{Optional scalar \code{integer} \code{tensor} specifying the starting
timestep. Default value: 0.}

\item{validate_args}{\code{logical}. Whether to validate input
with asserts. If \code{validate_args} is \code{FALSE}, and the inputs are
invalid, correct behavior is not guaranteed. Default value: \code{FALSE}.}

\item{allow_nan_stats}{\code{logical}. If \code{FALSE}, raise an
exception if a statistic (e.g. mean/mode/etc...) is undefined for any
batch member. If \code{TRUE}, batch members with valid parameters leading to
undefined statistics will return NaN for this statistic. Default value: \code{TRUE}.}

\item{name}{string prefixed to ops created by this class.
Default value: "SeasonalStateSpaceModel".}
}
\value{
an instance of \code{LinearGaussianStateSpaceModel}.
}
\description{
A state space model (SSM) posits a set of latent (unobserved) variables that
evolve over time with dynamics specified by a probabilistic transition model
\code{p(z[t+1] | z[t])}. At each timestep, we observe a value sampled from an
observation model conditioned on the current state, \code{p(x[t] | z[t])}. The
special case where both the transition and observation models are Gaussians
with mean specified as a linear function of the inputs, is known as a linear
Gaussian state space model and supports tractable exact probabilistic
calculations; see \code{tfd_linear_gaussian_state_space_model} for
details.
}
\details{
A seasonal effect model is a special case of a linear Gaussian SSM. The
latent states represent an unknown effect from each of several 'seasons';
these are generally not meteorological seasons, but represent regular
recurring patterns such as hour-of-day or day-of-week effects. The effect of
each season drifts from one occurrence to the next, following a Gaussian random walk:

\if{html}{\out{<div class="sourceCode">}}\preformatted{effects[season, occurrence[i]] = (effects[season, occurrence[i-1]] + Normal(loc=0., scale=drift_scale))
}\if{html}{\out{</div>}}

The latent state has dimension \code{num_seasons}, containing one effect for each
seasonal component. The parameters \code{drift_scale} and
\code{observation_noise_scale} are each (a batch of) scalars. The batch shape of
this \code{Distribution} is the broadcast batch shape of these parameters and of
the \code{initial_state_prior}.
Note: there is no requirement that the effects sum to zero.

Mathematical Details

The seasonal effect model implements a \code{tfd_linear_gaussian_state_space_model} with
\code{latent_size = num_seasons} and \code{observation_size = 1}. The latent state
is organized so that the \emph{current} seasonal effect is always in the first
(zeroth) dimension. The transition model rotates the latent state to shift
to a new effect at the end of each season:

\if{html}{\out{<div class="sourceCode">}}\preformatted{transition_matrix[t] = (permutation_matrix([1, 2, ..., num_seasons-1, 0])
                       if season_is_changing(t)
                       else eye(num_seasons)
transition_noise[t] ~ Normal(loc=0., scale_diag=(
                      [drift_scale, 0, ..., 0]
                      if season_is_changing(t)
                      else [0, 0, ..., 0]))
}\if{html}{\out{</div>}}

where \code{season_is_changing(t)} is \code{True} if \verb{t `mod` sum(num_steps_per_season)} is in
the set of final days for each season, given by \code{cumsum(num_steps_per_season) - 1}.
The observation model always picks out the effect for the current season, i.e.,
the first element of the latent state:

\if{html}{\out{<div class="sourceCode">}}\preformatted{observation_matrix = [[1., 0., ..., 0.]]
observation_noise ~ Normal(loc=0, scale=observation_noise_scale)
}\if{html}{\out{</div>}}
}
\seealso{
Other sts: 
\code{\link{sts_additive_state_space_model}()},
\code{\link{sts_autoregressive_state_space_model}()},
\code{\link{sts_autoregressive}()},
\code{\link{sts_constrained_seasonal_state_space_model}()},
\code{\link{sts_dynamic_linear_regression_state_space_model}()},
\code{\link{sts_dynamic_linear_regression}()},
\code{\link{sts_linear_regression}()},
\code{\link{sts_local_level_state_space_model}()},
\code{\link{sts_local_level}()},
\code{\link{sts_local_linear_trend_state_space_model}()},
\code{\link{sts_local_linear_trend}()},
\code{\link{sts_seasonal}()},
\code{\link{sts_semi_local_linear_trend_state_space_model}()},
\code{\link{sts_semi_local_linear_trend}()},
\code{\link{sts_smooth_seasonal_state_space_model}()},
\code{\link{sts_smooth_seasonal}()},
\code{\link{sts_sparse_linear_regression}()},
\code{\link{sts_sum}()}
}
\concept{sts}
