% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{as_event}
\alias{as_event}
\title{Coerce an object to a event.}
\usage{
as_event(x, step, wall_time, ...)
}
\arguments{
\item{x}{Object that will be coerced to an event.}

\item{step}{The step that will be used when the event is logged. This is used
by TensorBoard when showing data.}

\item{wall_time}{The all time the event will appended to the event. This field
is used by TensorBoard when displaying information based on actual time.}

\item{...}{currently unused.}
}
\value{
A event vctr with class <tfevents_event>.
}
\description{
Coerce an object to a event.
}
\section{Extending \code{as_event}}{


\code{as_event} is an S3 generic and you can implement method for your own class.
We don't export the \code{event} constructor though, so you should implement it
in terms of other \code{as_event} methods.
}

\examples{
as_event(list(hello = 1), step = 1, wall_time = 1)

}
