% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_spec.R
\name{step_remove_column}
\alias{step_remove_column}
\title{Creates a step that can remove columns}
\usage{
step_remove_column(spec, ...)
}
\arguments{
\item{spec}{A feature specification created with \code{\link[=feature_spec]{feature_spec()}}.}

\item{...}{Comma separated list of variable names to apply the step. \link{selectors} can also be used.}
}
\value{
a \code{FeatureSpec} object.
}
\description{
Removes features of the feature specification.
}
\examples{
\dontrun{
library(tfdatasets)
data(hearts)
hearts <- tensor_slices_dataset(hearts) \%>\% dataset_batch(32)

# use the formula interface
spec <- feature_spec(hearts, target ~ age) \%>\%
  step_numeric_column(age, normalizer_fn = scaler_standard()) \%>\%
  step_bucketized_column(age, boundaries = c(20, 50)) \%>\%
  step_remove_column(age)

spec_fit <- fit(spec)
final_dataset <- hearts \%>\% dataset_use_spec(spec_fit)
}

}
\seealso{
\link{steps} for a complete list of allowed steps.

Other Feature Spec Functions: 
\code{\link{dataset_use_spec}()},
\code{\link{feature_spec}()},
\code{\link{fit.FeatureSpec}()},
\code{\link{step_bucketized_column}()},
\code{\link{step_categorical_column_with_hash_bucket}()},
\code{\link{step_categorical_column_with_identity}()},
\code{\link{step_categorical_column_with_vocabulary_file}()},
\code{\link{step_categorical_column_with_vocabulary_list}()},
\code{\link{step_crossed_column}()},
\code{\link{step_embedding_column}()},
\code{\link{step_indicator_column}()},
\code{\link{step_numeric_column}()},
\code{\link{step_shared_embeddings_column}()},
\code{\link{steps}}
}
\concept{Feature Spec Functions}
