% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depth.R
\name{tf_depth}
\alias{tf_depth}
\alias{tf_depth.matrix}
\alias{tf_depth.tf}
\title{Functional Data Depth}
\usage{
tf_depth(x, arg, depth = "MBD", na.rm = TRUE, ...)

\method{tf_depth}{matrix}(x, arg, depth = "MBD", na.rm = TRUE, ...)

\method{tf_depth}{tf}(x, arg, depth = "MBD", na.rm = TRUE, ...)
}
\arguments{
\item{x}{\code{tf} (or a matrix of evaluations)}

\item{arg}{grid of evaluation points}

\item{depth}{currently available: "MBD", i.e. modified band depth}

\item{na.rm}{TRUE remove missing observations?}

\item{...}{further arguments handed to the function computing the respective
tf_depth.}
}
\value{
vector of tf_depth values
}
\description{
Data depths for functional data.
Currently implemented: Modified Band-2 Depth, see reference.
}
\references{
Sun, Ying, Genton, G M, Nychka, W D (2012).
\dQuote{Exact fast computation of band depth for large functional datasets: How quickly can one million curves be ranked?}
\emph{Stat}, \bold{1}(1), 68--74.

López-Pintado, Sara, Romo, Juan (2009).
\dQuote{On the concept of depth for functional data.}
\emph{Journal of the American statistical Association}, \bold{104}(486), 718--734.
}
\concept{tidyfun ordering and ranking functions}
