% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dtm2Docs.R
\name{Dtm2Docs}
\alias{Dtm2Docs}
\title{Convert a DTM to a Character Vector of documents}
\usage{
Dtm2Docs(dtm, ...)
}
\arguments{
\item{dtm}{A sparse Matrix from the matrix package whose rownames correspond 
to documents and colnames correspond to words}

\item{...}{Other arguments to be passed to \code{TmParallelApply}. See note, below.}
}
\value{
Returns a character vector. Each entry of this vector corresponds to the rows
of \code{dtm}.
}
\description{
This function takes a sparse matrix (DTM) as input and returns a character vector
whose length is equal to the number of rows of the input DTM.
}
\note{
This function performs parallel computation if \code{dtm} has more than 3,000
rows. The default is to use all available cores according to \code{parallel::detectCores()}.
However, this can be modified by passing the \code{cpus} argument when calling
this function.
}
\examples{
# Load a pre-formatted dtm and topic model
data(acq2) 

# see the original documents
documents[ 1:3 ]

# see the new documents re-structured from the DTM
new_docs <- Dtm2Docs(dtm=dtm)

new_docs[ 1:3 ]

}

