% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-textnets.R
\name{doc_centrality}
\alias{doc_centrality}
\title{Find a specified document centrality metric}
\usage{
doc_centrality(mat, method, alpha = 1L, scale = FALSE, two_mode = TRUE)
}
\arguments{
\item{mat}{Document-term matrix with terms as columns or a
document-similarity matrix with documents as rows and columns.}

\item{method}{Character vector indicating centrality method, including
weighted degree, eigenvector, spanning, and betweenness.}

\item{alpha}{Number (default = 1) indicating the tuning parameter for
weighted metrics.}

\item{scale}{Logical (default = FALSE), indicating whether to scale output.}

\item{two_mode}{Logical (default = TRUE), indicating whether the input matrix
is two mode (i.e. a document-term matrix) or one-mode
(i.e. document-similarity matrix)}
}
\value{
A dataframe with two columns
}
\description{
Given a document-term matrix or a document-similarity matrix,
this function returns specified text network-based centrality measures.
Currently, this includes weighted degree, eigenvector, betweenness, and
spanning.
}
\details{
If a document-term matrix is provided, the function obtains the one-mode
document-level projection to get the document-similarity matrix using
\code{tcrossprod()}. If a one-mode document-similarity matrix is provided, then
this step is skipped. This way document similiarities may be obtained
using other methods, such as Word-Mover's Distance. The diagonal is ignored
in all calculations.
}
\author{
Dustin Stoltz
}
