
#f <- system.file("ex/lux.shp", package="terra")
#y <- vect(f)
#y <- y[1:2,]
#x <- rast(y, res=.2)
#values(x) <- 1:ncell(x)
#expect_equal(cells(x, y), cbind(id=c(1,2), cell=c(1,5)))
#expect_equal(as.vector(cells(x, y, weights=TRUE)), c(1, 1, 1, 2, 2, 2, 1, 2, 5, 4, 5, 6, 0.55, 0.41, 0.04, 0.08, 0.51, 0.11))

#expect_equivalent(unlist(extract(x, y)), c(1,2,1,5))
#expect_equivalent(unlist(extract(x, y, cells=TRUE, weights=TRUE)), c(1, 1, 1, 2, 2, 2, 1, 2, 5, 4, 5, 6, 1, 2, 5, 4, 5, 6, 0.55, 0.41, 0.04, 0.08, 0.51, 0.11))


r <- rast(nrows=5, ncols=5, xmin=0, xmax=1, ymin=0, ymax=1, names="test")
r[c(2,7)] <- c(15, 20)
rr <- c(r, r/2)
names(rr)[2] <- "half"
xy <- cbind(x=0.3, y=c(0.9, 0.7))

v <- vect(xy)
e <- extract(r, v)
expect_equal(e, data.frame(ID=1:2, test=c(15,20)))
ee <- extract(rr, v)
expect_equal(ee, data.frame(ID=1:2, test=c(15,20), half=c(7.5, 10)))

e <- extract(r, v, cell=TRUE)
expect_equal(e, data.frame(ID=1:2, test=c(15,20), cell=c(2,7)))
ee <- extract(rr, v, cell=TRUE)
expect_equal(ee, data.frame(ID=1:2, test=c(15,20), half=c(7.5, 10), cell=c(2,7)))

ee <- extract(rr, v, cell=TRUE, xy=TRUE)
expect_equal(ee, data.frame(ID=1:2, test=c(15,20), half=c(7.5, 10), cell=c(2,7), xy))

ee <- extract(rr, v, xy=TRUE)
expect_equal(ee, data.frame(ID=1:2, test=c(15,20), half=c(7.5, 10), xy))

f <- system.file("ex/meuse.tif", package="terra")
r <- rast(f)
xy <- cbind(179000, 330000)
xy <- rbind(xy-100, xy, xy+1000)
e <- extract(r, xy)
expect_equal(e[,1] , c(378, 251, 208))

e <- extract(r, xy, method="bilinear")
expect_equal(e[,1] , c(378.00, 270.75, 197.25))

e <- extract(r, xy, method="bilinear", cells=T, xy=T)
expect_equal(unlist(e, use.names=FALSE), c(378.00, 270.75, 197.25,8173.00,8016.00,6041.00,178900.00, 179000.00, 180000.00, 329900.00, 330000.00, 331000.00))
	
 
