% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subgroups.R
\name{h_mmrm_subgroup_df}
\alias{h_mmrm_subgroup_df}
\title{Helper for Extraction and Formatting of MMRM Subgroups}
\usage{
h_mmrm_subgroup_df(
  lsmeans,
  overall_fit,
  is_in_subset,
  visit,
  treatment_arm,
  subgroup,
  var,
  label
)
}
\arguments{
\item{lsmeans}{(named \code{list} or \code{NULL})\cr LS mean estimates from \code{\link[=fit_mmrm]{fit_mmrm()}}
on this subgroup.}

\item{overall_fit}{(\code{tern_mmrm})\cr result of \code{\link[=fit_mmrm]{fit_mmrm()}} on overall data.}

\item{is_in_subset}{(\code{logical})\cr specifying which row from the overall data
should be used for this subset.}

\item{visit}{(\code{string})\cr which visit to extract.}

\item{treatment_arm}{(\code{string})\cr which treatment arm to extract.}

\item{subgroup}{(\code{string})\cr for labeling in the resulting \code{data.frame}.}

\item{var}{(\code{string})\cr specifies which variable was used to derive the subset,
if \code{ALL} then this means the overall data was used.}

\item{label}{(\code{string})\cr variable label.}
}
\value{
List with \code{estimates} (with 2 rows) and \code{contrasts} (with 1 row) in the
format needed in \code{\link[=extract_mmrm_subgroups]{extract_mmrm_subgroups()}}.
}
\description{
This is an internal helper to extract the correct LS mean estimates and
contrast for a specific visit and treatment arm relative to the reference
arm for one MMRM subgroup.
}
\keyword{internal}
