% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\name{stergm_prep}
\alias{stergm_prep}
\title{Prepare Network and STERGM Objects for tergmLite}
\usage{
stergm_prep(
  nw,
  formation,
  dissolution,
  coef.form,
  coef.diss,
  constraints,
  control = control.simulate.network()
)
}
\arguments{
\item{nw}{An object of class \code{network}.}

\item{formation}{Right-hand sided formation formula.}

\item{dissolution}{Right-hand sided dissolution formula.}

\item{coef.form}{Vector of coefficients associated with the formation formula.}

\item{coef.diss}{Vector of coefficients associated with the dissolution formula.}

\item{constraints}{Constraints for the formation model (only \code{bd})
constraints currently supported.}

\item{control}{Control settings passed to \code{tergm::control.simulate.network}.}
}
\value{
Returns a list class object with four elements:
\itemize{
  \item{\code{model.form}}: Formation model coefficients and data elements.
  \item{\code{model.diss}}: Dissolution model coefficients and data elements.
  \item{\code{MHproposal.form}}: Formation model constraint data elements.
  \item{\code{MHproposal.diss}}: Dissolution model constraint data elements.
}
}
\description{
Converts network object, formation and dissolution formulas,
             formation and dissolution coefficients, and control settings to a
             thin list format for STERGM resimulation.
}
\details{
This is an internal function used within \code{\link{init_tergmLite}}. It is
not exported from the package but it is documented here to demonstrate the
internal inputs for \code{\link{init_tergmLite}}.
}
