% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.duration.R
\name{degrange.mean.age-ergmTerm}
\alias{degrange.mean.age-ergmTerm}
\alias{InitErgmTerm.degrange.mean.age}
\title{Average age of ties incident on nodes having degree in a given range}
\usage{
# binary: degrange.mean.age(from, to=+Inf, byarg=NULL, emptyval=0)
}
\arguments{
\item{from, to}{vectors of distinct
integers or \code{+Inf} , for \code{to} . If one of the vectors has
length 1, it is recycled to the length of the other. Otherwise, they
must have the same length.}

\item{byarg}{specifies a vertex attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.). If specified, then separate degree
statistics are calculated for nodes having each separate
value of the attribute.}

\item{emptyval}{can be used to specify the value returned if the network does not have any actors
with degree in the specified range. This is, technically, an arbitrary value, but it should
not have a substantial effect unless a non-negligible fraction of
networks at the parameter configuration of interest has no actors
with specified degree.}
}
\description{
Average age of ties incident on nodes having degree in a given range
}
\details{
This term adds one
network statistic to the model for each element of \code{from} (or \code{to} ); the \eqn{i} th
such statistic equals the average, among all ties incident on nodes
with degree greater than or equal to
\code{from[i]} but strictly less than \code{to[i]} , of the amount of time elapsed
since the tie's formation. The optional argument
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "degrange.mean.age", "subsection")}
}
\concept{durational}
