% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equi_mcmc.R
\name{sample_right_wishart}
\alias{sample_right_wishart}
\title{Gibbs update of \code{Phi_inv}.}
\usage{
sample_right_wishart(nu, V)
}
\arguments{
\item{nu}{A numeric. The degrees of freedom in the mirror-Wishart.}

\item{V}{A matrix. The inverse of the scale matrix in the
mirror-Wishart.}
}
\value{
\code{C} An upper triangular matrix such that \code{C \%*\% t(C)} is
  a sample from the mirror-Wishart(\code{nu}, \code{V ^ -1}) distribution.
}
\description{
Samples an upper triangular Cholesky square root of a
mirror-Wishart distributed random variable.
}
\details{
Let \eqn{X} be mirror-Wishart(\eqn{\nu}, \eqn{V^-1}). Then This code
returns an upper triangular \eqn{C} where \eqn{X = CC'}. This
function is used primarily during the Gibbs updates of the inverse
of the lower triangular Cholesky square root of the component
covariance matrices in \code{equi_mcmc}.
}
\author{
David Gerard.
}
\references{
Gerard, D., & Hoff, P. (2015).
  \href{http://www.sciencedirect.com/science/article/pii/S0047259X15000330}{Equivariant
  minimax dominators of the MLE in the array normal model}. \emph{Journal of
  Multivariate Analysis}, 137, 32-49.
}
\seealso{
\code{\link{equi_mcmc}}, \code{\link{rmirror_wishart}}.
}
\keyword{equivariance}
\keyword{simulation}

