% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asserts.r
\name{all_are_numeric}
\alias{all_are_numeric}
\alias{assert_all_are_numeric}
\title{Are all values numeric?}
\usage{
all_are_numeric(x, .xname = get_name_in_parent(x))

assert_all_are_numeric(x, severity = getOption("assertive.severity",
  "stop"))
}
\arguments{
\item{x}{An R object or expression.}

\item{.xname}{Not intended to be used directly.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
\code{all_are_numeric} returns \code{TRUE} if \code{x} contains only
numeric values.The \code{assert_*} function throws an error on failure.
}
\description{
Checks if the input object only contains numeric values.
}
\seealso{
\code{\link[base]{is.numeric}},
\code{\link[assertive.types]{is_numeric}}
}
\keyword{internal}
