% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imperative.R
\name{tf_imperative}
\alias{tf_imperative}
\title{Imperative style TensorFlow}
\usage{
tf_imperative(expr, new_step = FALSE, convert = TRUE)
}
\arguments{
\item{expr}{A block of code expession}

\item{new_step}{A boolean indicating whether the expression is evaluated as a new step.
A graph is constructed and kept around in the background, both for just executing using
the standard TensorFlow runtime, and also for allowing automatic differentiation via \code{tf$gradients}.
If this is set to \code{TRUE}, the graph as well as the cached tensors that have been kept around for
gradient computation will be cleared after the expression is evaluated.}

\item{convert}{A boolean indicating whether to convert the returned Tensor object to base R object.}
}
\description{
The results of the computation are available right after the execution of a line of code.
If the return value is Tensor, it can be converted to base R object automatically if \code{convert = TRUE}
is specified. Users can also call \code{tensor$eval()} to convert any Tensor objects inside the \code{expr}
scope to base R objects.
}
\details{
Note that this function is currently only experimental, meaning that the interface is subject
to change or remove at later releases.
}
\examples{
\dontrun{

tf_imperative({
  a <- tf$constant(list(list(7), list(6)))
  b <- tf$constant(list(list(6, 7)))
  list(
   tf$matmul(a, b),
   a * 4
  )
})

# This is equivalent to the following:

tf <- tf$contrib$imperative
a <- tf$constant(list(list(7), list(6)))
b <- tf$constant(list(list(6, 7)))
res1 <- tf$matmul(a, b)
res2 <- a * 4
list(res1$eval(), res2$eval())

}
}
