% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_tests.R
\name{weighted_rayleigh}
\alias{weighted_rayleigh}
\title{Weighted Goodness-of-fit Test for Circular Data}
\usage{
weighted_rayleigh(x, prd = NULL, unc, axial = TRUE)
}
\arguments{
\item{x}{numeric vector. Values in degrees}

\item{prd}{The a priori expected direction (in degrees) for the alternative
hypothesis.}

\item{unc}{numeric. The standard deviations of \code{x}. If \code{NULL}, the non-weighted
Rayleigh test is performed.}

\item{axial}{logical. Whether the data are axial, i.e. \eqn{\pi}-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}
}
\value{
a list with the components:
\describe{
\item{\code{statistic}}{Test statistic}
\item{\code{p.value}}{significance level of the test statistic}
}
}
\description{
Weighted version of the Rayleigh test (or V0-test) for uniformity against a
distribution with a priori expected von Mises concentration.
}
\details{
The Null hypothesis is uniformity (randomness). The alternative is a
distribution with a specified mean direction (\code{prd}).
If \code{statistic > p.value}, the null hypothesis is rejected.
If not, the alternative cannot be excluded.
}
\examples{
# Load data
data("cpm_models")
data(san_andreas)
PoR <- equivalent_rotation(subset(cpm_models, model == "NNR-MORVEL56"), "na", "pa")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
data("iceland")
PoR.ice <- equivalent_rotation(subset(cpm_models, model == "NNR-MORVEL56"), "eu", "na")
ice.por <- PoR_shmax(iceland, PoR.ice, "out")
data("tibet")
PoR.tib <- equivalent_rotation(subset(cpm_models, model == "NNR-MORVEL56"), "eu", "in")
tibet.por <- PoR_shmax(tibet, PoR.tib, "in")

# GOF test:
weighted_rayleigh(tibet.por$azi.PoR, prd = 90, unc = tibet$unc)
weighted_rayleigh(ice.por$azi.PoR, prd = 0, unc = iceland$unc)
weighted_rayleigh(sa.por$azi.PoR, prd = 135, unc = san_andreas$unc)
}
\seealso{
\code{\link[=rayleigh_test]{rayleigh_test()}}
}
