% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tleaves.R
\name{energy_balance}
\alias{energy_balance}
\title{Calculate leaf energy balance}
\usage{
energy_balance(
  tleaf,
  leaf_par,
  enviro_par,
  constants,
  quiet = FALSE,
  components = FALSE,
  set_units = FALSE
)
}
\arguments{
\item{tleaf}{Leaf temperature in Kelvin. If input is numeric, it will be automatically converted to \code{units}.}

\item{leaf_par}{A list of leaf parameters. This can be generated using the \code{make_leafpar} function.}

\item{enviro_par}{A list of environmental parameters. This can be generated using the \code{make_enviropar} function.}

\item{constants}{A list of physical constants. This can be generated using the \code{make_constants} function.}

\item{quiet}{Logical. Should a message appear about conversion from \code{numeric} to \code{units}? Useful for finding leaf temperature that balances heat transfer using \code{\link[stats]{uniroot}}.}

\item{components}{Logical. Should leaf energy components be returned? Transpiration (in mol / (m^2 s)) also returned.}

\item{set_units}{Logical. Should \code{units} be set? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}
}
\value{
A numeric value in W / m^2. Optionally, a named list of energy balance components in W / m^2 and transpiration in mol / (m^2 s).
}
\description{
Calculate leaf energy balance
}
\examples{

library(tealeaves)

cs <- make_constants()
ep <- make_enviropar()
lp <- make_leafpar()

T_leaf <- set_units(298.15, K)

energy_balance(T_leaf, lp, ep, cs, FALSE, TRUE, TRUE)

}
