% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_utils.R
\name{conv_str_logi}
\alias{conv_str_logi}
\title{Convert \code{yaml} representation of a boolean strings to logical Values}
\usage{
conv_str_logi(
  input,
  name = "",
  pos_logi = c("TRUE", "true", "True", "yes", "y", "Y", "on"),
  neg_logi = c("FALSE", "false", "False", "no", "n", "N", "off"),
  silent = TRUE
)
}
\arguments{
\item{input}{(\code{character(1)})}

\item{name}{(\code{charcter(1)})}

\item{pos_logi}{(\code{character}) vector of \code{yaml} values which should be treated as \code{TRUE}.}

\item{neg_logi}{(\code{character}) vector of \code{yaml} values which should be treated as \code{FALSE}.}

\item{silent}{(\code{logical(1)}) if to suppress the messages and warnings.}
}
\value{
\code{input} argument or the appropriate \code{logical} value.
}
\description{
Converts a single \code{character} string representing a \code{yaml} boolean value into a logical value in \code{R}.
}
\examples{

conv_str_logi <- getFromNamespace("conv_str_logi", "teal.reporter")
conv_str_logi("TRUE")
conv_str_logi("True")

conv_str_logi("off")
conv_str_logi("n")

conv_str_logi("sth")
}
\keyword{internal}
