% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_handlers.R
\name{register_handlers}
\alias{register_handlers}
\title{Register handlers for logging messages, warnings and errors}
\usage{
register_handlers(namespace, package = namespace)
}
\arguments{
\item{namespace}{(\code{character(1)}) the logger namespace}

\item{package}{(\code{character(1)}) the package name}
}
\value{
\code{NULL} invisibly. Called for its side effects.
}
\description{
Register handlers for logging messages, warnings and errors
}
\details{
This function registers global handlers for messages, warnings and errors.
The handlers will investigate the call stack and if it contains a function
from the package, the message, warning or error will be logged into the respective
namespace.

The handlers are registered only once per package and type. Consecutive calls will no effect.
Registering handlers for package \code{base} is not supported.

Use \code{TEAL.LOG_MUFFLE} environmental variable or \code{teal.log_muffle} R option to optionally
control recover strategies. If \code{TRUE} (a default value) then the handler will jump to muffle
restart for a given type of condition and doesn't continue (with output to the console).
Applicable for message and warning types only. The errors won't be suppressed.
}
\note{
Registering handlers is forbidden within \code{tryCatch()} or \code{withCallingHandlers()}.
Because of this, handlers are registered only if it is possible.
}
\examples{
\dontrun{
register_handlers("teal.logger")
# see the outcome
globalCallingHandlers()
}
}
\seealso{
\code{\link[=globalCallingHandlers]{globalCallingHandlers()}}
}
