% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limitOrder.R
\name{limitOrder}
\alias{limitOrder}
\title{Place limit order}
\usage{
limitOrder(
  token = "",
  live = FALSE,
  figi = "",
  direction = NULL,
  lots = NULL,
  price = NULL
)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{figi}{internal tinkoff code for instrument}

\item{direction}{"Buy" or "Sell"}

\item{lots}{number of lots to buy}

\item{price}{price of limit order}
}
\value{
returns a list object containing the information about state of operation.
}
\description{
this function will place your order in to account.
}
\details{
As described by the official Tinkoff Investments documentation. If you want live trading, use sandbox=FALSE with live token
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
paper_token = 'your_sandbox_token_from_tcs_account'
limitOrder(paper_token,figi='BBG005HLTYH9',direction='Buy',lots=1,price=100)

live_token = 'your_live_token_from_tcs_account'
# remember that this command will place limit order in your live account !
limitOrder(live_token,live=TRUE,figi='BBG005HLTYH9',direction='Buy',lots=1,price=100)
}
\seealso{
\code{\link{marketOrder}}
}
\author{
Vyacheslav Arbuzov
}
