% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getQuotes.R
\name{getQuotes}
\alias{getQuotes}
\title{Download current quotes for instrument}
\usage{
getQuotes(token = "", live = FALSE, figi = "", verbose = FALSE)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{figi}{internal tinkoff code for instrument}

\item{verbose}{display status of retrieval (default FALSE)}
}
\value{
returns an data.table object containing the requested data with current quotes for instrument.
}
\description{
Makes a request to the server, and returns an data.table object with information about orderbook for selected instrument if successful.
}
\details{
Information gets from orderbook function.
Also gets list of availible status of instrument: break_in_trading, normal_trading, not_available_for_trading, closing_auction, closing_period, discrete_auction, opening_period, trading_at_closing_auction_price
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
live = FALSE
token = 'your_sandbox_token_from_tcs_account'
getQuotes(token,live,figi = 'BBG005HLTYH9')
}
\author{
Vyacheslav Arbuzov
}
