% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitgnls.R
\name{fitgnls}
\alias{fitgnls}
\title{Gain-Loss Model Fit}
\usage{
fitgnls(
  conc,
  resp,
  bidirectional = TRUE,
  verbose = FALSE,
  nofit = FALSE,
  minwidth = 1.5
)
}
\arguments{
\item{conc}{Vector of concentration values NOT in log units.}

\item{resp}{Vector of corresponding responses.}

\item{bidirectional}{If TRUE, model can be positive or negative; if FALSE, it
will be positive only.}

\item{verbose}{If TRUE, gives optimization and hessian inversion details.}

\item{nofit}{If nofit = TRUE, returns formatted output filled with missing values.}

\item{minwidth}{Minimum allowed distance between gain ac50 and loss ac50 (in
log10 units).}
}
\value{
Named list containing: success, aic (Aikaike Information Criteria),
  cov (success of covariance calculation), rme (root mean square error),
  modl (vector of model values at given concentrations),
  parameters values, parameter sd (standard deviation) estimates, pars
  (vector of parameter names), sds (vector of parameter sd names).
}
\description{
Function that fits to f(x) = tp/[(1 + (ga/x)^p )(1 + (x/la)^q )]
and returns generic model outputs.
}
\details{
Concentrations are converted internally to log10 units and optimized with
f(x) = tp/[(1 + 10^(p*(ga-x)) )(1 + 10^(q*(x-la)) )], then ga, la, ga_sd,
and la_sd are converted back to regular units before returning.
Zero background and increasing initial absolute response are assumed.
Parameters are "tp" (top), "ga" (gain AC50), "p" (gain power), "la"
(loss AC50),"q" (loss power) and error term "er".
success = 1 for a successful fit, 0 if optimization failed, and NA if
nofit = TRUE. cov = 1 for a successful hessian inversion, 0 if it fails, and NA
if nofit = TRUE. aic, rme, modl, parameters, and parameter sds are set to
NA in case of nofit or failure.
}
\examples{
fitgnls(c(.03,.1,.3,1,3,10,30,100), c(0,.3,1, 2, 2.1, 1.5, .8, .2))
}
