% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplMultiplot.R
\name{tcplMultiplot}
\alias{tcplMultiplot}
\title{Plot summary fits based on fit and dose-response data}
\usage{
tcplMultiplot(dat, agg, flg = NULL, boot = NULL, browse = FALSE,
  hitc.all)
}
\arguments{
\item{dat}{data.table, level 4 or level 5 data, see details.}

\item{agg}{data.table, concentration-response aggregate data, see details.}

\item{flg}{data.table, level 6 data, see details.}

\item{boot}{data.table, level 7 data, see details.}

\item{browse}{Logical, should \code{browser()} be called after every plot?}

\item{hitc.all}{Logical, if FALSE, only plots with hitc==1 will be displayed}
}
\description{
\code{tcplMultiplot} takes the dose-response and fit data and produces
summary plot figures.
}
\details{
The data for 'dat', 'agg', and 'flg' should be loaded using the 
\code{\link{tcplLoadData}} function with the appropriate 'lvl' parameter.
See help page for \code{tcplLoadData} for more information.

If dat contains only one aeid, plots will be ordered by chemical name (chnm). 
Otherwise, plots are ordered by assay endpoint name (aenm).
## While it is most likely the user will want to just save all of the plots 
## to view in a PDF, the 'browse' parameter can be used to quickly view 
## some plots.
}
