% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc4_mthds.R
\name{MC4_Methods}
\alias{MC4_Methods}
\alias{mc4_mthds}
\title{List of level 4 multiple-concentration methods for calculating bmad}
\usage{
mc4_mthds()
}
\value{
A list of functions
}
\description{
\code{mc4_mthds} returns a list of methods to be used 
during level 4 multiple-concentration processing for calculating bmad
}
\details{
The functions contained in the list returned by \code{mc4_mthds} take 
'aeids' (a numeric vector of aeid values) and returns a list of expressions 
to be executed in the \code{mc4} (not exported) function environment. The 
functions are described here for reference purposes, The 
\code{mc4_mthds} function is not exported, nor is it intended for use.

All available methods are described in the Available Methods section, listed
by the type of function and the function/method name.
}
\note{
This function is not exported and is not intended to be used by the user.
}
\section{Available Methods}{



Although it does not say so specifically in each description, all methods 
are applied by aeid.

More information about the level 4 multiple-concentration processing is 
available in the package vignette, "Pipeline_Overview."

  \describe{
    \item{bmad.aeid.lowconc.twells}{bmad based on two lowest concentration of treatment wells}
    \item{bmad.aeid.lowconc.nwells}{bmad based on two lowest concentration of nwells}
  }
}

\seealso{
\code{\link{mc4}}, \code{\link{Method functions}} to query what 
methods get applied to each aeid
}
