% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{simulate.poppkmod}
\alias{simulate.poppkmod}
\title{Summary method for `poppkmod` objects}
\usage{
\method{simulate}{poppkmod}(
  object,
  nsim = 1,
  seed = NULL,
  ...,
  inf,
  tms,
  obs_cmpt = 1,
  resp_bounds = NULL
)
}
\arguments{
\item{object}{An object with class "poppkmod" generated by `poppkmod`}

\item{nsim}{Number of observations to simulate at each time point. Defaults to 1.}

\item{seed}{An integer used to initialize the random number generator.}

\item{...}{Arguments passed to `update.pkmod`.}

\item{inf}{A matrix of infusion rates with columns 'begin', 'end', and 'inf_rate'. This
can be created manually, by `inf_manual`, or by `inf_tci`.}

\item{tms}{Times at which to simulate observations.}

\item{obs_cmpt}{Integer value indicating compartment in which observations are taken.
Overridden if a PD model is included.}

\item{resp_bounds}{Optional vector of two values indicating minimum and maximum values possible for the response.}
}
\description{
Summarize parameter distribution
Simulate method for poppkmod objects
}
\details{
Simulate observations from a poppkmod object
}
\examples{
# simulate data from a 2 compartment model with multiplicative error
dose <- inf_manual(inf_tms = c(0,0.5,4,4.5,10), inf_rate = c(100,0,80,0,0))
# poppkmod object
data <- data.frame(ID = 1:5, AGE = seq(20,60,by=10), TBW = seq(60,80,by=5),
 HGT = seq(150,190,by=10), MALE = c(TRUE,TRUE,FALSE,FALSE,FALSE))
elvd_mod <- poppkmod(data, drug = "ppf", model = "eleveld")
inf <- inf_tci(elvd_mod, target_vals = c(2,3,4,4), target_tms = c(0,2,3,10), "plasma")
simulate(elvd_mod, nsim = 3, inf = inf, tms = c(1,2,4,6,10))
}
