% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{simulate.pkmod}
\alias{simulate.pkmod}
\title{Simulate method for pkmod objects}
\usage{
\method{simulate}{pkmod}(
  object,
  nsim = 1,
  seed = NULL,
  ...,
  inf,
  tms,
  obs_cmpt = 1,
  resp_bounds = NULL
)
}
\arguments{
\item{object}{An object with class "pkmod" generated by `pkmod`}

\item{nsim}{Number of observations to simulate at each time point. Defaults to 1.}

\item{seed}{An integer used to initialize the random number generator.}

\item{...}{Arguments passed to `update.pkmod`.}

\item{inf}{A matrix of infusion rates with columns 'begin', 'end', and 'inf_rate'. This
can be created manually, by `inf_manual`, or by `inf_tci`.}

\item{tms}{Times at which to simulate observations.}

\item{obs_cmpt}{Integer value indicating compartment in which observations are taken.
Overridden if a PD model is included.}

\item{resp_bounds}{Optional vector of two values indicating minimum and maximum values possible for the response.}
}
\description{
Simulate observations from a pkmod object
}
\examples{
# simulate data from a 2 compartment model with multiplicative error
dose <- inf_manual(inf_tms = c(0,0.5,4,4.5,10), inf_rate = c(100,0,80,0,0))
my_mod <- pkmod(pars_pk = c(CL = 10, V1 = 10, Q2 = 4, V2 = 30))
inf <- inf_tci(my_mod, target_vals = c(2,3,4,4), target_tms = c(0,2,3,10), "plasma")
simulate(my_mod, nsim = 3, inf = inf, tms = c(1,2,4,6,10), sigma_mult = 0.2)
# simulate with PD model
my_mod_pd <- pkmod(pars_pk = c(v1 = 8.995, v2 = 17.297, v3 = 120.963, cl = 1.382,
q2 = 0.919, q3 = 0.609, ke0 = 1.289),
pars_pd = c(c50 = 2.8, gamma = 1.47, gamma2 = 1.89, e0 = 93, emx = 93),
pdfn = emax, pdinv = emax_inv, ecmpt = 4)
simulate(my_mod_pd, inf = dose, tms = c(1.5,2.5,3))
}
