% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkpd_assist.R
\name{format_pars}
\alias{format_pars}
\title{Format parameters for use in Rcpp functions

Order parameters for 1-4 compartment models to be used in Rcpp functions in
predict.pkmod method.}
\usage{
format_pars(pars, ncmpt = 3)
}
\arguments{
\item{pars}{Vector of named parameters. Names can be capitalized or lowercase
and can include variations of "V1" as "V" or clearance terms rather than
elimination rate constants.}

\item{ncmpt}{Number of compartments in the model. This should be a value
between 1 and 4. If ncmpt = 4, it assumes that the fourth compartment is an
effect-site without a corresponding volume parameter.}
}
\description{
Format parameters for use in Rcpp functions

Order parameters for 1-4 compartment models to be used in Rcpp functions in
predict.pkmod method.
}
\examples{
dose <- data.frame(time = c(0.5,4,4.5,10), infrt = c(100,0,100,0))
create_intvl(dose)
}
