% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synonymize_subspecies.R
\name{synonymize_subspecies}
\alias{synonymize_subspecies}
\title{Convert all subspecies into synonyms of the species}
\usage{
synonymize_subspecies(master, verbose = FALSE)
}
\arguments{
\item{master}{List of names with a field named canonical}

\item{verbose}{display process messages, Default: FALSE}
}
\value{
Same list of names with id and accid fields added (or data updated
the fields exists) with all subspecies linked to the species names as
synonyms
}
\description{
used in generating master lists
}
\details{
While dealing with taxonomic names only at specific level,
to take advantage of sub-specific names already available in the lists
are sometimes treated as synonyms of the names at species rank. To
convert all the subspecies names as synonyms this function is very handy.
}
\examples{
\dontrun{
newmaster <- synonymize_subspecies(master)
}
}
\seealso{
Other list functions: 
\code{\link{DwC2taxo}()},
\code{\link{match_lists}()}
}
\concept{list functions}
