% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{read.nodes}
\alias{read.nodes}
\title{Read NCBI nodes file}
\usage{
read.nodes(nodeFile)
}
\arguments{
\item{nodeFile}{string giving the path to an NCBI node file to read from (both gzipped or uncompressed files are ok)}
}
\value{
a data.table with columns id, parent and rank with a key on id
}
\description{
Take an NCBI nodes file and convert it to a data.table. NOTE: This function is now deprecated for \code{\link{read.nodes.sql}} (using SQLite rather than data.table).
}
\examples{
nodes<-c(
 "1\t|\t1\t|\tno rank\t|\t\t|\t8\t|\t0\t|\t1\t|\t0\t|\t0\t|\t0\t|\t0\t|\t0\t|\t\t|",
 "2\t|\t131567\t|\tsuperkingdom\t|\t\t|\t0\t|\t0\t|\t11\t|\t0\t|\t0\t|\t0\t|\t0\t|\t0\t|\t\t|",
 "6\t|\t335928\t|\tgenus\t|\t\t|\t0\t|\t1\t|\t11\t|\t1\t|\t0\t|\t1\t|\t0\t|\t0\t|\t\t|",
 "7\t|\t6\t|\tspecies\t|\tAC\t|\t0\t|\t1\t|\t11\t|\t1\t|\t0\t|\t1\t|\t1\t|\t0\t|\t\t|",
 "9\t|\t32199\t|\tspecies\t|\tBA\t|\t0\t|\t1\t|\t11\t|\t1\t|\t0\t|\t1\t|\t1\t|\t0\t|\t\t|"
)
tmpFile<-tempfile()
writeLines(nodes,tmpFile)
read.nodes(tmpFile)
}
\references{
\url{ftp://ftp.ncbi.nih.gov/pub/taxonomy/}
}
\seealso{
\code{\link{read.names}}, \code{\link{read.nodes.sql}}
}
