% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{getAccessions}
\alias{getAccessions}
\title{Find all accessions for a taxa}
\usage{
getAccessions(taxaId, sqlFile, version = c("version", "base"),
  limit = NULL)
}
\arguments{
\item{taxaId}{a vector of taxonomic IDs}

\item{sqlFile}{a string giving the path to a SQLite file created by \code{\link{read.accession2taxid}}}

\item{version}{either 'version' indicating that taxaids are versioned e.g. Z17427.1 or 'base' indicating that taxaids do not have version numbers e.g. Z17427}

\item{limit}{return only this number of accessions or NULL for no limits}
}
\value{
a vector of character strings giving taxa IDs (potentially comma concatenated for any taxa with ambiguous names)
}
\description{
Find accessions numbers for a given taxa ID the NCBI taxonomy. This will be pretty slow unless the database was built with indexTaxa=TRUE since the database would not have an index for taxaId.
}
\examples{
taxa<-c(
  "accession\\taccession.version\\ttaxid\\tgi",
  "Z17427\\tZ17427.1\\t3702\\t16569",
  "Z17428\\tZ17428.1\\t3702\\t16570",
  "Z17429\\tZ17429.1\\t3702\\t16571",
  "Z17430\\tZ17430.1\\t3702\\t16572"
)
inFile<-tempfile()
outFile<-tempfile()
writeLines(taxa,inFile)
read.accession2taxid(inFile,outFile)
getAccessions(3702,outFile)
}
\seealso{
\code{\link{read.accession2taxid}}
}
