% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2taxlist.R
\name{df2taxlist}
\alias{df2taxlist}
\alias{df2taxlist.data.frame}
\alias{df2taxlist,data.frame-method}
\alias{df2taxlist.character}
\alias{df2taxlist,character-method}
\title{Convert data frames and strings into taxlist objects}
\usage{
df2taxlist(x, ...)

\method{df2taxlist}{data.frame}(x, taxonTraits, taxonViews, levels, clean_strings = TRUE, ...)

\method{df2taxlist}{character}(x, ...)
}
\arguments{
\item{x}{A data frame or a character vector with taxonomic names. If x is
a data frame, the columns \strong{TaxonUsageID} (integer with IDs for each
name), \strong{TaxonConceptID} (integer with IDs for the respective taxon
concepts), and \strong{TaxonName} (character) are mandatory.
Other optional columns are \strong{AuthorName} (character with names'
authorities), \strong{AcceptedName} (logical indicating whether the name is
an accepted name or a synonym and will be set as TRUE by default),
\strong{Level}
(factor sorting taxonomic ranks in the bottom-up direction), \strong{Parent}
(integer, the taxon concept ID of the parental taxon), and \strong{ViewID}
(integer pointing to the ID of taxonomic view, usually a bibliographic
reference, and will be used only if 'taxonViews' is provided.
Any further column not included in the prototype of taxlist will be
considered as names' attributes and inserted in slot \strong{taxonNames}.}

\item{...}{Further arguments passed among methods. For the
\code{'character-method'}, arguments will be passed to the
\code{'data.frame-method'}.}

\item{taxonTraits}{A data frame with attributes of taxonomic concepts
(optional). If provided, the column \strong{TaxonConceptID} is mandatorial.}

\item{taxonViews}{A data frame or \linkS4class{lib_df} with references of taxonomic
views (optional). If provided, the column \strong{ViewID} is mandatorial and
have to match the homonymous column at 'x'.}

\item{levels}{A character vector setting the levels or taxonomic ranks from
the bottom to the top. This argument is optional and if missing, the
column \strong{Level} will be preserved (if factor) or coerced to factor,
except in the case that no column \strong{Level} is provided.}

\item{clean_strings}{Logical value, whether function \code{\link[=clean_strings]{clean_strings()}} should
be applied to 'x' or not.}
}
\value{
A \linkS4class{taxlist} object.
}
\description{
Function converting template data frame into \linkS4class{taxlist} object.
Also character vectors including taxonomic names will be converted
but without any information on taxonomic ranks and parental taxa.
}
\examples{
Cyperus <- read.csv(file = file.path(path.package("taxlist"), "cyperus",
  "names.csv"))
head(Cyperus)

## Convert to 'taxlist' object
Cyperus$AcceptedName <- !Cyperus$SYNONYM
df2taxlist(Cyperus)

## Create a 'taxlist' object from character vectors
Plants <- df2taxlist(c("Triticum aestivum", "Zea mays"), AuthorName = "L.")
summary(Plants, "all")
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}.
}
