% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_taxa.R
\name{count_taxa}
\alias{count_taxa}
\alias{count_taxa,character,missing-method}
\alias{count_taxa,factor,missing-method}
\alias{count_taxa,taxlist,missing-method}
\alias{count_taxa,formula,taxlist-method}
\title{Count taxa within a taxlist object.}
\usage{
count_taxa(object, data, ...)

\S4method{count_taxa}{character,missing}(object, na.rm = TRUE, ...)

\S4method{count_taxa}{factor,missing}(object, na.rm = TRUE, ...)

\S4method{count_taxa}{taxlist,missing}(object, level, ...)

\S4method{count_taxa}{formula,taxlist}(object, data, include_na = FALSE, suffix = "_count", ...)
}
\arguments{
\item{object}{An object containing a taxonomic list or a formula.}

\item{data}{An object of class \linkS4class{taxlist} in the \code{formula} method.}

\item{...}{further arguments passed among methods.}

\item{na.rm}{Logical value, whether NAs have to be removed from the input
vector or not.}

\item{level}{Character value indicating the taxonomic rank of counted taxa.}

\item{include_na}{Logical value indicating whether \code{NA} values in a taxon
trait should be considered for counting taxa or just ignored (only
used in \code{formula} method).}

\item{suffix}{Character value used as suffix for the counted rank in the
output data frame (only used in \code{formula} method).}
}
\value{
An integer with the number of taxa.
}
\description{
Counting number of taxa within \linkS4class{taxlist} objects or
character vectors containing taxon names.
}
\details{
This function is written by convenience in order to reduce code for counting
taxa within \linkS4class{taxlist} objects and it is just a wrapper of \code{\link[=length]{length()}}.
}
\examples{
## factor method
count_taxa(iris$Species)

## taxlist method
count_taxa(Easplist)
count_taxa(Easplist, level="species")

## using a formula
count_taxa(~ lf_behn_2018, Easplist)

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
