% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop.R
\name{pop}
\alias{pop}
\title{Pop taxa out}
\usage{
pop(.data, ...)
}
\arguments{
\item{.data}{Input, object of class \code{Hierarchy}, or \code{hierarchies}}

\item{...}{quoted rank names (e.g., family) via \code{\link[=ranks]{ranks()}}, taxon names
(e.g., Poa annua) via \code{\link[=nms]{nms()}}, or taxonomic IDs (e.g., 93036) via \code{\link[=ids]{ids()}}.
You can't pass in arbitrary strings or numbers.}
}
\value{
an object of the same class as passed in
}
\description{
Pop out taxa, that is, drop them
}
\details{
supports \code{Hierarchy} and \code{hierarchies} objects
}
\examples{
# With Hierarchy class object
ex_hierarchy1
## ranks
pop(ex_hierarchy1, ranks("family"))
ex_hierarchy1 \%>\% pop(ranks("family"))
ex_hierarchy1 \%>\% pop(ranks("family", "genus"))
## taxon names
ex_hierarchy1 \%>\% pop(nms("Poa"))
ex_hierarchy1 \%>\% pop(nms("Poaceae", "Poa"))
## taxon ids
ex_hierarchy1 \%>\% pop(ids(4479))
ex_hierarchy1 \%>\% pop(ids(4479, 4544))
## mixed: ids and names
ex_hierarchy1 \%>\% pop(ranks("family"), ids(4544))

# With hierarchies class object
# single taxonomic group
invisible(lapply(ex_hierarchies, print))
ex_hierarchies \%>\% pop(ranks("family")) \%>\% lapply(., print) \%>\% invisible
## more than one taxonomic group
invisible(lapply(ex_hierarchies, print))
ex_hierarchies \%>\% pop(ranks("family", "genus")) \%>\% lapply(., print) \%>\%
  invisible
}
\seealso{
See \link{filtering-helpers}, including for more explanation
of how this function works.
}
