% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_workbook.R
\name{as_workbook}
\alias{as_workbook}
\alias{as_workbook.default}
\alias{as_workbook.Tatoo_report}
\alias{save_xlsx}
\alias{view_xlsx}
\title{Convert a Tatoo Table Object to an Excel Workbook}
\usage{
as_workbook(x, ...)

\method{as_workbook}{default}(x, sheet = 1L, ...)

\method{as_workbook}{Tatoo_report}(x, ...)

save_xlsx(x, outfile, overwrite = FALSE, ...)

view_xlsx(x, ...)
}
\arguments{
\item{x}{A \code{Tatoo_table} or \code{Tatoo_report}}

\item{...}{Additional arguments passed on to \code{write_worksheet()}}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{outfile}{Path to the output file}

\item{overwrite}{If \code{TRUE}, overwrite any existing file.}
}
\value{
\code{as_workbook()} returns an openxlsx \code{Workbook} object.

\code{save_xlsx()} returns the path to the saved \file{.xlsx} (invisibly).

\code{view_xlsx()} opens an external program and returns \code{NULL} (invisibly).
}
\description{
\code{as_workbook()} converts \code{\link{Tatoo_table}} or \code{\link{Tatoo_report}} objects directly
to \link{openxlsx} \code{Workbook} objects. For information about additional parameters
please refer to the documentation of \code{\link[=write_worksheet]{write_worksheet()}}, for which
\code{as_workbook()} is just a wrapper. Additional possible function arguments way
vary depending on which \code{Tatoo_table} you want to export.

\code{save_xlsx()} is a wrapper for saving a \code{Tatoo_table} directly
to an \file{xlsx} file.

\code{view_xlsx()} is another wrapper for viewing a \code{Tatoo_table}"s
\file{xlsx} representation in your favorite spreadsheet program (powered by
\code{\link[openxlsx:openXL]{openxlsx::openXL()}}).
}
\examples{
\dontrun{
dat <- data.frame(
  Species = c("setosa", "versicolor", "virginica"),
  length = c(5.01, 5.94, 6.59),
  width = c(3.43, 2.77, 2.97)
)

# Assign metadata to convert dat to a Tagged_table

title(dat) <- "Iris excerpt"
footer(dat) <-  "An example based on the iris dataset"


# Convert to Workbook or save als xlsx

wb <- as_workbook(dat)
save_xlsx(dat, tempfile(fileext = ".xlsx"), overwrite = TRUE)
}

}
\seealso{
Other xlsx exporters: 
\code{\link{write_worksheet}()}
}
\concept{xlsx exporters}
