% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_format_get.R
\name{tar_format_get}
\alias{tar_format_get}
\title{Current storage format.}
\usage{
tar_format_get()
}
\value{
A character string, storage format of the target currently
running in the pipeline. If called outside a target in the running
pipeline, \code{\link[=tar_format_get]{tar_format_get()}} will return the default format given by
\code{tar_option_get("format")}.
}
\description{
Get the storage format of the target currently running.
}
\details{
This function is meant to be called inside a target in a
running pipeline. If it is called outside a target in the running
pipeline, it will return the default format given by
\code{tar_option_get("format")}.
}
\examples{
tar_target(x, tar_format_get(), format = "qs")
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_backoff}()},
\code{\link{tar_call}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_described_as}()},
\code{\link{tar_envir}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path}()},
\code{\link{tar_path_script}()},
\code{\link{tar_path_script_support}()},
\code{\link{tar_path_store}()},
\code{\link{tar_path_target}()},
\code{\link{tar_source}()},
\code{\link{tar_store}()},
\code{\link{tar_unblock_process}()}
}
\concept{utilities}
