% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_delete.R
\name{tar_delete}
\alias{tar_delete}
\title{Delete locally stored target return values.}
\usage{
tar_delete(names, cloud = TRUE, store = targets::tar_config_get("store"))
}
\arguments{
\item{names}{Names of the targets to remove from \verb{_targets/objects/}.
You can supply symbols
or \code{tidyselect} helpers like \code{\link[=any_of]{any_of()}} and \code{\link[=starts_with]{starts_with()}}.}

\item{cloud}{Logical of length 1, whether to delete objects
from the cloud if applicable (e.g. AWS, GCP). If \code{FALSE},
files are not deleted from the cloud.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\description{
Delete the return values of targets in \verb{_targets/objects/}.
but keep the records in \verb{_targets/meta/meta}.
}
\details{
If you have a small number of data-heavy targets you
need to discard to conserve storage, this function can help.
Local external files files (i.e. \code{format = "file"}
and \code{repository = "local"}) are not deleted.
For targets with \code{repository} not equal \code{"local"}, \code{tar_delete()} attempts
to delete the file and errors out if the deletion is unsuccessful.
If deletion fails, either log into the cloud platform
and manually delete the file (e.g. the AWS web console
in the case of \code{repository = "aws"}) or call
\code{\link[=tar_invalidate]{tar_invalidate()}} on that target so that \code{targets}
does not try to delete the object.
For patterns recorded in the metadata, all the branches
will be deleted. For patterns no longer in the metadata,
branches are left alone.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_make()
tar_delete(starts_with("y")) # Only deletes y1 and y2.
tar_make() # y1 and y2 rebuild but return same values, so z is up to date.
})
}
}
\seealso{
Other clean: 
\code{\link{tar_destroy}()},
\code{\link{tar_invalidate}()},
\code{\link{tar_prune}()}
}
\concept{clean}
