% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Other.R
\name{stdfEmp}
\alias{stdfEmp}
\title{Empirical stable tail dependence function}
\usage{
stdfEmp(ranks, k, cst = rep(1, ncol(ranks)))
}
\arguments{
\item{ranks}{A \code{n} x \code{d} matrix, where each column is a permutation of the integers \code{1:n}, representing the ranks computed from a sample of size \code{n}.}

\item{k}{An integer between 1 and \eqn{n - 1}; the threshold parameter in the definition of the empirical stable tail dependence function.}

\item{cst}{The value in which the tail dependence function is evaluated: defaults to \code{rep(1,d)}, i.e., the extremal coefficient.}
}
\value{
A scalar between \eqn{\max(x_1,\ldots,x_d)} and \eqn{x_1 + \cdots + x_d}.
}
\description{
Returns the stable tail dependence function in dimension \code{d}, evaluated in a point \code{cst}.
}
\examples{
## Simulate data from the Gumbel copula and compute the extremal coefficient in dimension four.
set.seed(2)
cop <- copula::gumbelCopula(param = 2, dim = 4)
data <- copula::rCopula(n = 1000, copula = cop)
stdfEmp(apply(data,2,rank), k = 50)
}
\references{
Einmahl, J.H.J., Kiriliouk, A., and Segers, J. (2016). A continuous updating weighted least squares estimator of tail dependence in high dimensions. See http://arxiv.org/abs/1601.04826.
}
\seealso{
\code{\link{stdfEmpCorr}}
}

