% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rarefaction.R
\docType{methods}
\name{index_baxter}
\alias{index_baxter}
\alias{index_baxter-method}
\alias{index_baxter,numeric-method}
\title{Baxter's Rarefaction}
\usage{
index_baxter(x, ...)

\S4method{index_baxter}{numeric}(x, sample, ...)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector of count data (absolute frequencies).}

\item{...}{Currently not used.}

\item{sample}{A length-one \code{\link{numeric}} vector giving the sub-sample size.
The size of sample should be smaller than total community size.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Baxter's Rarefaction
}
\references{
Baxter, M. J. (2001). Methodological Issues in the Study of Assemblage
Diversity. \emph{American Antiquity}, 66(4), 715-725. \doi{10.2307/2694184}.
}
\seealso{
Other alpha diversity measures: 
\code{\link{index_ace}()},
\code{\link{index_berger}()},
\code{\link{index_boone}()},
\code{\link{index_brillouin}()},
\code{\link{index_chao1}()},
\code{\link{index_chao2}()},
\code{\link{index_hurlbert}()},
\code{\link{index_ice}()},
\code{\link{index_margalef}()},
\code{\link{index_mcintosh}()},
\code{\link{index_menhinick}()},
\code{\link{index_shannon}()},
\code{\link{index_simpson}()},
\code{\link{index_squares}()}
}
\author{
N. Frerebeau
}
\concept{alpha diversity measures}
