% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabula-package.R
\docType{package}
\name{tabula-package}
\alias{tabula-package}
\alias{_PACKAGE}
\alias{tabula}
\title{tabula: Analysis, Seriation and Visualization of Archaeological
    Count Data}
\description{
\if{html}{\figure{logo.png}{options: align='right'}}

An easy way to examine archaeological count data. This package 
    provides a convenient and reproducible toolkit for relative and absolute 
    dating and analysis of (chronological) patterns. It includes functions for 
    matrix seriation (reciprocal ranking, CA-based seriation), chronological 
    modeling and dating of archaeological assemblages and/or objects. 
    Beyond these, the package provides several tests and measures of diversity: 
    heterogeneity and evenness (Brillouin, Shannon, Simpson, etc.), 
    richness and rarefaction (Chao1, Chao2, ACE, ICE, etc.), 
    turnover and similarity (Brainerd-Robinson, etc.). 
    The package make it easy to visualize count data and statistical thresholds: 
    rank vs. abundance plots, heatmaps, Ford (1962) and Bertin (1977) diagrams.
}
\details{
\tabular{ll}{
 \strong{Package:} \tab tabula \cr
 \strong{Type:} \tab Package \cr
 \strong{Version:} \tab 1.3.0 \cr
 \strong{License:} \tab GPL-3 \cr
 \strong{DOI:} \tab \href{https://doi.org/10.5281/zenodo.1489944}{10.5281/zenodo.1489944}
}
}
\note{
This work received a state financial support managed by the Agence Nationale
de la Recherche (France) through the program \emph{Investissements d'avenir}
(ref. ANR-10-LABX-52).
}
\seealso{
Useful links:
\itemize{
  \item \url{http://tabula.archaeo.science}
  \item \url{http://github.com/nfrerebeau/tabula}
  \item \url{https://cran.r-project.org/package=tabula}
  \item Report bugs at \url{http://github.com/nfrerebeau/tabula/issues}
}

}
\author{
\strong{Full list of authors and contributors} (alphabetic order)

\tabular{ll}{
 Nicolas Frerebeau \tab \emph{Université Bordeaux Montaigne, France} \cr
 Jean-Baptiste Fourvel \tab \emph{CNRS, France} \cr
 Brice Lebrun \tab \emph{Aix-Marseille Université, France} \cr
 Ben Marwick \tab \emph{University of Washington, USA} \cr
 Matthew Peeples \tab \emph{Arizona State University, USA} \cr
 Anne Philippe \tab \emph{Université de Nantes, France} \cr
}

\strong{Package maintainer}

Nicolas Frerebeau\cr
\email{nicolas.frerebeau@u-bordeaux-montaigne.fr}

IRAMAT-CRP2A (UMR 5060)\cr
Maison de l'Archéologie\cr
Université Bordeaux Montaigne\cr
F-33607 Pessac cedex\cr
France
}
\keyword{internal}
