% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plotMatrix}
\alias{plotMatrix}
\alias{plotMatrix-method}
\alias{matrigraphe}
\alias{plotMatrix,CountMatrix-method}
\alias{plotMatrix,FrequencyMatrix-method}
\alias{plotMatrix,IncidenceMatrix-method}
\title{Matrix plot}
\usage{
plotMatrix(object, ...)

\S4method{plotMatrix}{CountMatrix}(object, PVI = FALSE)

\S4method{plotMatrix}{FrequencyMatrix}(object, PVI = FALSE)

\S4method{plotMatrix}{IncidenceMatrix}(object)
}
\arguments{
\item{object}{An object to be plotted.}

\item{...}{Further arguments passed to other methods.}

\item{PVI}{A \code{\link{logical}} scalar: should the PVI be drawn instead of
frequencies (see details)?}
}
\description{
Plots a heatmap.
}
\details{
If \code{PVI} is \code{FALSE}, it plots a heatmap of relative abundances
 (frequency), otherwise percentages of the independence value are drawn (in
 french, "pourcentages de valeur d'indépendance", PVI).

 \code{PVI} is calculated for each cell as the percentage to the column
 theoretical independence value: \code{PVI} greater than \eqn{1} represent
 positive deviations from the independance, whereas \code{PVI} smaller than
 \eqn{1} represent negative deviations (Desachy 2004).

 The \code{PVI} matrix allows to explore deviations from independence
 (an intuitive graphical approach to \eqn{\chi^2}{Chi-squared}),
 in such a way that a high-contrast matrix has quite significant deviations,
 with a low risk of being due to randomness (Desachy 2004).
}
\examples{
# Abundance data
## Coerce dataset to abundance matrix
## Data from Desachy 2004
count <- as(compiegne, "CountMatrix")

# Plot matrix diagram...
## ...without threshod (i.e. heatmap)
plotMatrix(count)

## ...with PVI as threshold (i.e. Bruno Desachy's matrigraphe)
plotMatrix(count, PVI = TRUE) +
  ggplot2::scale_fill_gradient2(midpoint = 1)

# Presence/absence data
bin <- IncidenceMatrix(data = sample(0:1, size = 100, replace = TRUE),
                       nrow = 10, ncol = 10)

# Plot matrix diagram
plotMatrix(bin) +
  ggplot2::scale_fill_manual(values = c("TRUE" = "black", "FALSE" = "white"))
}
\references{
Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
 graphique pour tableaux de comptages. \emph{Revue archéologique de
 Picardie}, 3(1), 39-56.
 DOI: \href{https://doi.org/10.3406/pica.2004.2396}{10.3406/pica.2004.2396}.
}
\seealso{
Other plot: \code{\link{plotBar}}, \code{\link{plotDate}},
  \code{\link{plotRank}}, \code{\link{plotSpot}}
}
\author{
N. Frerebeau
}
\concept{plot}
