% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tablet.R
\name{as_kable.tablet}
\alias{as_kable.tablet}
\title{Coerce Tablet to Kable}
\usage{
\method{as_kable}{tablet}(
  x,
  ...,
  booktabs = TRUE,
  escape = FALSE,
  escape_latex = function(x, ...) gsub("\%", "\\\\\\\\\%", x),
  escape_html = function(x, ...) x,
  variable = " ",
  col.names = NA,
  linebreak = TRUE,
  align = "c",
  double_escape = FALSE,
  linebreaker = "\\n",
  pack_rows = list()
)
}
\arguments{
\item{x}{\code{\link{tablet}}}

\item{...}{passed to \code{\link[kableExtra]{kbl}}}

\item{booktabs}{passed to \code{\link[kableExtra]{kbl}}}

\item{escape}{passed to \code{\link[kableExtra]{kbl}}; defaults FALSE to allow header linebreaks}

\item{escape_latex}{a function to pre-process column content if 'escape' is FALSE (e.g., manual escaping, latex only)}

\item{escape_html}{a function to pre-process column content if 'escape' is FALSE (e.g., manual escaping, html only)}

\item{variable}{a column name for the variables}

\item{col.names}{passed to \code{\link[kableExtra]{kbl}} after any linebreaking}

\item{linebreak}{whether to invoke \code{\link[kableExtra]{linebreak}} for column names}

\item{align}{passed to \code{\link[kableExtra]{linebreak}} for column names}

\item{double_escape}{passed to \code{\link[kableExtra]{linebreak}} for column names}

\item{linebreaker}{passed to \code{\link[kableExtra]{linebreak}} for column names in latex; for html, newline is replaced with <br>}

\item{pack_rows}{named list passed to \code{\link[kableExtra]{pack_rows}} for finer control of variable names}
}
\value{
like \code{\link[kableExtra]{kbl}}
}
\description{
Renders a tablet.  Calls \code{\link[kableExtra]{kbl}} and implements
special features like grouped columns.
}
\examples{
library(boot)
library(dplyr)
library(magrittr)
melanoma \%>\%
  select(-time, -year) \%>\%
  mutate(sex = factor(sex), ulcer = factor(ulcer)) \%>\%
  group_by(status) \%>\%
  tablet \%>\%
  as_kable
}
