% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_styles.R
\name{tbl_styles}
\alias{tbl_styles}
\title{tbl_styles}
\usage{
tbl_styles(
  bg_default = openxlsx::createStyle(fgFill = "#ffffff"),
  bg_title = bg_default,
  bg_subtitle = bg_default,
  bg_header_lhs = bg_default,
  bg_header_rhs = bg_default,
  bg_rownames = bg_default,
  bg_data = bg_default,
  bg_footnote = bg_default,
  vline = openxlsx::createStyle(border = "Left", borderColour = "#000000", borderStyle =
    "thin"),
  hline = openxlsx::createStyle(border = "Top", borderColour = "#000000", borderStyle =
    "thin"),
  cell_default = openxlsx::createStyle(fontSize = 11),
  cell_title = openxlsx::createStyle(fontSize = 14, halign = "left", textDecoration =
    "bold"),
  cell_subtitle = openxlsx::createStyle(fontSize = 11, halign = "left", textDecoration =
    "bold"),
  cell_header_lhs = openxlsx::createStyle(fontSize = 11, halign = "center", border =
    "BottomLeftRight", borderColour = "#000000", borderStyle = "thin", textDecoration =
    "bold"),
  cell_header_rhs = openxlsx::createStyle(fontSize = 11, halign = "center", border =
    "BottomLeftRight", borderColour = "#000000", borderStyle = "thin", textDecoration =
    "bold"),
  cell_rownames = cell_default,
  cell_data = cell_default,
  cell_footnote = openxlsx::createStyle(fontSize = 11, halign = "left"),
  merge_rownames = TRUE,
  merged_rownames_style = openxlsx::createStyle(valign = "top"),
  footnote_style = openxlsx::createStyle(fontSize = 11, halign = "left"),
  data_styles = create_data_styles(),
  cell_styles = NULL
)
}
\arguments{
\item{bg_default}{default color for the background of the table}

\item{bg_title}{background color for the title}

\item{bg_subtitle}{background color for the subtitle}

\item{bg_header_lhs}{background color for the left hand side of the table header}

\item{bg_header_rhs}{background color for the right hand side of the table header}

\item{bg_rownames}{background color for the row names}

\item{bg_data}{background color for the data}

\item{bg_footnote}{background color for the footnote}

\item{vline}{styling for all vertical lines added to the table}

\item{hline}{styling for all horizontal lines added to the table}

\item{cell_default}{default style added to cells in the table}

\item{cell_title}{style added to title cells in the table}

\item{cell_subtitle}{style added to subtitle cells in the table}

\item{cell_header_lhs}{style added to the left hand side of the header cells in the table}

\item{cell_header_rhs}{style added to the right hand side of the header cells in the table}

\item{cell_rownames}{style added to row name cells in the table}

\item{cell_data}{style added to data cells in the table}

\item{cell_footnote}{style added to footnote cells in the table}

\item{merge_rownames}{boolean: Should adjacent rows with identical names be merged?}

\item{merged_rownames_style}{style applied to the merged rownames}

\item{footnote_style}{style applied to the table footnote}

\item{data_styles}{styles applied to the columns in the data set based on their
classes (e.g., numeric, character, etc.). data_styles must be a list of lists.
Each inner list must have two elements: a "test" that is used to determine the
class of a data column (e.g., is.double) and a style that is then applied to
the columns where the test returns TRUE. Note that styles will be applied in the
order of the list, meaning that a later style may overwrite an earlier style.}

\item{cell_styles}{an optional list with styles for selected cells in the
data frame. See ?cell_style.}
}
\value{
a list with styles for different elements of the table
}
\description{
Define styles for different elements of the table.
}
\examples{
tbl_styles()
}
