% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_styles.R
\name{create_data_styles}
\alias{create_data_styles}
\title{create_data_styles}
\usage{
create_data_styles(
  double = list(test = is.double, style = openxlsx::createStyle(numFmt = "0.00")),
  integer = list(test = is.integer, style = openxlsx::createStyle(numFmt = "0")),
  ...
)
}
\arguments{
\item{double}{style for columns of type double}

\item{integer}{style for columns of type integer}

\item{...}{add further styles}
}
\value{
a list of lists with styles
}
\description{
This function sets some defaults for data_styles. See ?tbl_styles
}
\details{
Styles are applied to the columns in the data set based on their
classes (e.g., numeric, character, etc.). data_styles must be a list of lists.
Each inner list must have two elements: a "test" that is used to determine the
class of a data colum (e.g., is.double) and a style that is then applied to
the columns where the test returns TRUE. Note that styles will be applied in the
order of the list, meaning that a later style may overwrite an earlier style.
}
\examples{
library(tablespan)
# Make all booleans bold:
create_data_styles(boolean = list(test = is.logical,
                   style = openxlsx::createStyle(textDecoration = "bold")))
}
