\name{XLoneWay}
\alias{XLoneWay}
\title{One-way Contingency Tables exported to a spreadsheet}
\usage{
XLoneWay(wb, sheet, rowvar, title = NULL, rowTitle = "Value",
  rowNames = NULL, ord = NULL, row1 = 1, col1 = 1, purge = FALSE,
  digits = ifelse(length(rowvar) >= 200, 1, 0), combine = TRUE,
  useNA = "ifany")
}
\arguments{
  \item{wb}{a \code{\link[XLConnect]{workbook-class}}
  object}

  \item{sheet}{numeric or character: a worksheet name
  (character) or position (numeric) within \code{wb}.}

  \item{rowvar}{vector: the categorical variable (logical,
  numeric, character, factor, etc.) to be tabulated}

  \item{title}{character: an optional overall title to the
  table. Default (\code{NULL}) is no title.}

  \item{rowTitle}{character: the title to be placed above
  the row name column (default empty string)}

  \item{rowNames}{character: vector of row names. Default
  behavior (\code{NULL}): automatically determined from
  data}

  \item{ord}{numeric vector specifying row-index order in
  the produced table. Default (\code{NULL}) is no
  re-ordering.}

  \item{row1,col1}{numeric: the first row and column
  occupied by the table (title included if relevant).}

  \item{purge}{logical should \code{sheet} be created anew,
  by first removing the previous copy if it exists?
  (default \code{FALSE})}

  \item{digits}{numeric: how many digits (after the decimal
  point) to show in the percents? Defaults to 1 if n>=200,
  0 otherwise.}

  \item{combine}{logical: should counts and percentab be
  combined to the popular \code{"Count(percent)"} format,
  or presented side-by-side? (default \code{TRUE})}

  \item{useNA}{How to handle missing values. Passed on to
  \code{\link{table}} (see help on that function for
  options).}
}
\value{
The function returns invisibly, after writing the data into
\code{sheet} and saving the file.
}
\description{
Calculates a one-way contingency table in counts and
percents, exports a formatted output to a spreadsheet, and
saves the file.
}
\details{
This function performs a one-way contingency table, also
calculating the distribution in percents.

The table is then exported to worksheet \code{sheet} in
workbook \code{wb}, either using the format
\code{"Count(percent)"} (if \code{combine=TRUE}), or as two
separate columns in the same table.

See the \code{\link{XLtwoWay}} help page, for behavior
regarding new-sheet creation, overwriting, etc.
}
\examples{
book1<-XLwriteOpen("chick1.xls") 
XLoneWay(book1,"Diets",ChickWeight$Diet)
### Now in separate columns, and with a title - note it shifts the table down.
XLoneWay(book1,"Diets",ChickWeight$Diet,combine=FALSE,row1=10,
         rowTitle="Diet",title="Counts by Diet:")
cat("Look for",paste(getwd(),"chick1.xls",sep='/'),"to see the results!\\n")
}
\author{
Assaf P. Oron \code{<assaf.oron.at.seattlechildrens.org>}
}
\seealso{
If interested in other descriptive summaries, see
\code{\link{XLunivariate}}. For two-way contingency tables,
see \code{\link{XLtwoWay}}.
}

