% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fromParallelTP.R
\name{fromParallelTP}
\alias{fromParallelTP}
\title{Function to extract raw data from parallel calculations of trophic position}
\usage{
fromParallelTP(df = NULL, get = NULL)
}
\arguments{
\item{df}{data frame, variable where it was saved the output from parallel
calculations of TP}

\item{get}{string, could be either "TP", "alpha" or "summary." In case of TP
this function will extract the trophic position data, in case of alpha, this
function will extract the alpha parameter data, and in case of summary, it
will return a data frame ready to plot with the function credibilityIntervals.}
}
\value{
when selecting "TP" or "alpha", this function returns a posteriorTP
or a posteriorAlpha object with the data. When selecting "summary", this
function returns a data frame ready to be used with credibilityIntervals().
}
\description{
This function parses a data frame where it was stored the data from parallel
calculations using multiModelTP and a list of isotopeData class objects.
}
\examples{
\dontrun{
data("Bilagay")
BilagayList <- extractIsotopeData(Bilagay,
communityColumn = "Location",speciesColumn = "FG",
b1 = "Pelagic_BL", b2 = "Benthic_BL",
baselineColumn = "FG",
deltaC = TDF(author = "McCutchan", element = "C", type = "muscle"),
deltaN = TDF(author = "McCutchan", element = "N", type = "muscle"))
Bilagay_TPmodels <- parallel::parLapply(cluster,
BilagayList, multiModelTP, adapt = 20000,
n.iter = 20000, burnin = 20000, n.chains = 5,
model = "twoBaselinesFull")
ggplot_df <- fromParallelTP(Bilagay_TPmodels, get = "summary")
credibilityIntervals(ggplot_df, x = "community",
xlab = "Location along N-S gradient")
}

}
