% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_BM.R
\name{data.gen.fbm}
\alias{data.gen.fbm}
\title{Generate a time series of fractional Brownian motion.}
\usage{
data.gen.fbm(
  hurst = 0.95,
  time = seq(0, by = 0.01, length.out = 1000),
  do.plot = TRUE
)
}
\arguments{
\item{hurst}{the hurst index, with the default value 0.95, ranging from [0,1].}

\item{time}{the temporal interval at which the system will be generated. Default seq(0,by=0.01,len=1000).}

\item{do.plot}{a logical value. If TRUE (default value), a plot of the generated system is shown.}
}
\description{
This function generates a a time series of one dimension fractional Brownian motion.
}
\examples{
set.seed(123)
x <- data.gen.fbm()
}
\references{
Zdravko Botev (2020). Fractional Brownian motion generator (https://www.mathworks.com/matlabcentral/fileexchange/38935-fractional-brownian-motion-generator), MATLAB Central File Exchange. Retrieved August 17, 2020.

Kroese, D. P., & Botev, Z. I. (2015). Spatial Process Simulation. In Stochastic Geometry, Spatial Statistics and Random Fields(pp. 369-404) Springer International Publishing, DOI: 10.1007/978-3-319-10064-7_12
}
