% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_AR.R
\name{data.gen.ar9}
\alias{data.gen.ar9}
\title{Generate predictor and response data from AR9 model.}
\usage{
data.gen.ar9(nobs, ndim = 9)
}
\arguments{
\item{nobs}{The data length to be generated.}

\item{ndim}{The number of potential predictors (default is 9).}
}
\value{
A list of 2 elements: a vector of response (x), and a matrix of potential predictors (dp) with each column containing one potential predictor.
}
\description{
Generate predictor and response data from AR9 model.
}
\examples{
# AR9 model from paper with total 9 dimensions
data.ar9<-data.gen.ar9(500)
plot.ts(cbind(data.ar9$x,data.ar9$dp))
}
